import os

from core.models.deepMDP_mdl import DeepMDPModel
from core.components.logger import Logger
from core.utils.general_utils import AttrDict
from core.configs.default_data_configs.vizdoom import data_spec
from core.components.evaluator import DummyEvaluator
from core.data.vizdoom.vizdoom_data_loader import VizdoomDataset


current_dir = os.path.dirname(os.path.realpath(__file__))


configuration = {
    'model': DeepMDPModel,
    'model_test': DeepMDPModel,
    'logger': Logger,
    'logger_test': Logger,
    'evaluator': DummyEvaluator,
    'data_dir': os.path.join(os.environ['DATA_DIR'], './vizdoom'),
    'num_epochs': 100,
    'epoch_cycles_train': 4,
    'batch_size': 32,
    'discount_factor': 0.99,
    'n_frames': 4,
}
configuration = AttrDict(configuration)

model_config = {
    'action_dim': 1,
    'img_sz': 64,
    'nz_enc': 256,
    'nz_mid': 256,
    'nz_mid_lstm': 256,
    'nz_vae': 128,
    'ngf': 8,
    'input_nc': 4,
    'normalization': 'none',
}

# Dataset
data_config = AttrDict()
data_config.dataset_spec = data_spec
data_config.dataset_spec.dataset_class = VizdoomDataset
data_config.dataset_spec.discount_factor = 0.4
data_config.dataset_spec.split = AttrDict(train=0.99, val=0.01, test=0.0)
data_config.dataset_spec.max_seq_len = 500
data_config.dataset_spec.crop_rand_subseq = True
data_config.dataset_spec.subseq_len = 2
data_config.dataset_spec.task_names = ['0_0-0_0-1_0', '0_0-1_0-0_0', '1_0-1_0--1_0']
data_config.dataset_spec.obj_labels = ['Clip', 'CustomMediKit', 'ZoomImp']
data_config.dataset_spec.delta_t=1

